
export default {
    router: {
        // base :'/Ashkan/',
        base :'/',
        extendRoutes(routes) {
            routes.push({
                path: "/",
                component: "~/pages/index.vue"
            });
        }
    },
  subdirectory: '/',
    // target: 'server',
    ssr:true,
    components:true,
    // buildDir: './dist',
  /*
  ** Headers of the page
  */
  head: {
    title: '',
    description : "",
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, height=device-height,  initial-scale=1.0, user-scalable=no,user-scalable=0' },
    ],
    link: [
      { rel: 'icon', type: 'image/x-icon', href: '/favicon.png' },
      { rel: 'stylesheet', href: 'https://fonts.googleapis.com/css?family=Lato:300,400,700,900' },
        // { rel: 'stylesheet', href: '~/assets/scss/shahab.scss' }
    ],
    script: [
      // { src: 'https://checkout.stripe.com/checkout.js'}
    ]
  },
  /*
  ** Customize the progress-bar color
  */
  loading: { color: '#ff4c3b', throttle: 200, height: '3px', css: true },
  /*
  ** Global CSS
  */
  css: [
      '~/assets/scss/app-rtl.scss',
      // "vuetify/css/styles/main.sass"
      //'swiper/swiper.scss',
      //'swiper/swiper-bundle.css',
  ],
  /*
  ** Plugins to load before mounting the App
  */
  // pwa: {
      manifest: {
          name: 'MyShemsh !',
          short_name: 'MyShemSh',
          lang: 'fa',
          gcm_sender_id: "XXXXXXXXXXX",
          icons: [
              {
                  src: "/static/favicon.png",
                  sizes: "32x32",
                  type: "image/png"
              }
          ],
      },
  // },
    buildModules: [
        '@nuxtjs/vuetify','@nuxtjs/color-mode','@nuxtjs/pwa'
        // '@nuxtjs/html-validator'
    ],
  plugins: [
      "~/plugins/axios.js",
      "~/plugins/simplebar.js",
      {src:"~/plugins/vue-googlemap.js",ssr:false},
      {src:'~/plugins/plugin.js',ssr:false},
     { src: '~/plugins/localStorage.js', ssr:false },
     "~/plugins/chartist.js",

     // '~/plugins/localStorage.js',
      // { src: '@/plugins/swiper.js', ssr:false },
      // {src:'~/plugins/star-rating.js',ssr:false},
      // {src:'~/plugins/loading.js',ssr:false}
  ],
  /*
  ** Nuxt.js modules
  */
  modules: [
    // Doc: https://axios.nuxtjs.org/usage
    'bootstrap-vue/nuxt',
    '@nuxtjs/axios',

    // 'vue-scrollto/nuxt',
      // 'nuxt-i18n',
      // '@nuxtjs/proxy',
      ['cookie-universal-nuxt', { parseJSON: false }],
      ['nuxt-gmaps', {
          key: 'AIzaSyDI-vpkwYxxZmOc2TXnpOiY_pIF4UZoHec'
      }]
      // 'nuxt-sass-resources-loader',
      // ['./assets/scss/app.scss'],
  ],
    // i18n: {
    //     locales: ['fa'],
    //     defaultLocale: 'fa',
    //     vueI18n: {
    //         fallbackLocale: 'fa',
    //         messages: {
    //             fa: require('./locales/fa.json')
    //         }
    //     },
    // },
  /*
  ** Axios module configuration
  ** See https://axios.nuxtjs.org/options
  */
    // axios: {
        // proxy: true // Can be also an object with default options
    // },
    // proxy: {
    //     'http://localhost:3000/Ashkan': {target: 'http://api.myshemsh.com' }
    // },
  generate: {
    fallback: true
  },
  /*
  ** Build configuration
  */
  build: {
      // extractCSS: false,
      minifyCSS: true,
      // minifyJS: true,
    // transpile: [
    //   "vee-validate/dist/rules"
    // ],
    //   extend (config, ctx) {
    //       config.resolve.symlinks = false
    //   }
    /*
    ** You can extend webpack config here
    */
    // extend(config, ctx) {
    // }
  },
  axios:{
    baseURL: process.env.base_url
  },
  env:{
    base_url : process.env.base_url,
    socket_url : process.env.socket_url,
    roles_icon_url : process.env.roles_icon_url,

  }
}
